<?php

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Qodef_Uncovering_Sections extends WPBakeryShortCodesContainer {}
	class WPBakeryShortCode_Qodef_Uncovering_Sections_Item extends WPBakeryShortCodesContainer {}
}

if ( ! function_exists( 'cevian_core_add_uncovering_sections_shortcodes' ) ) {
	function cevian_core_add_uncovering_sections_shortcodes( $shortcodes_class_name ) {
		$shortcodes = array(
			'CevianCore\CPT\Shortcodes\UncoveringSections\UncoveringSections',
			'CevianCore\CPT\Shortcodes\UncoveringSections\UncoveringSectionsItem'
		);
		
		$shortcodes_class_name = array_merge( $shortcodes_class_name, $shortcodes );
		
		return $shortcodes_class_name;
	}
	
	add_filter( 'cevian_core_filter_add_vc_shortcode', 'cevian_core_add_uncovering_sections_shortcodes' );
}

if ( ! function_exists( 'cevian_core_set_uncovering_sections_custom_style_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom css style for full screen sections holder shortcode
	 */
	function cevian_core_set_uncovering_sections_custom_style_for_vc_shortcodes( $style ) {
		$current_style = '.vc_shortcodes_container.wpb_qodef_uncovering_sections_item { 
			background-color: #f4f4f4; 
		}';
		
		$style .= $current_style;
		
		return $style;
	}
	
	add_filter( 'cevian_core_filter_add_vc_shortcodes_custom_style', 'cevian_core_set_uncovering_sections_custom_style_for_vc_shortcodes' );
}

if ( ! function_exists( 'cevian_core_set_uncovering_sections_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for full screen sections holder shortcode to set our icon for Visual Composer shortcodes panel
	 */
	function cevian_core_set_uncovering_sections_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-uncovering-sections';
		$shortcodes_icon_class_array[] = '.icon-wpb-uncovering-sections-item';
		
		return $shortcodes_icon_class_array;
	}
	
	add_filter( 'cevian_core_filter_add_vc_shortcodes_custom_icon_class', 'cevian_core_set_uncovering_sections_icon_class_name_for_vc_shortcodes' );
}

if ( ! function_exists( 'cevian_core_set_uncovering_sections_header_top_custom_styles' ) ) {
    /**
     * Function that set custom icon class name for full screen sections holder shortcode to set our icon for Visual Composer shortcodes panel
     */
    function cevian_core_set_uncovering_sections_header_top_custom_styles() {
        $top_header_height = cevian_select_options()->getOptionValue( 'top_bar_height' );

        if ( ! empty( $top_header_height ) ) {
            echo cevian_select_dynamic_css( '.qodef-uncovering-section-on-page:not(.qodef-header-bottom).qodef-header-top-enabled .qodef-top-bar', array( 'top' => '-' . cevian_select_filter_px( $top_header_height ) . 'px' ) );
            echo cevian_select_dynamic_css( '.qodef-uncovering-section-on-page:not(.qodef-header-bottom).qodef-header-top-enabled:not(.qodef-sticky-header-appear) .qodef-page-header', array( 'top' => cevian_select_filter_px( $top_header_height ) . 'px' ) );
        }
    }

    add_action( 'cevian_select_action_style_dynamic', 'cevian_core_set_uncovering_sections_header_top_custom_styles' );
}