<?php
namespace CevianCore\CPT\Shortcodes\Team;

use CevianCore\Lib;

class TeamHolder implements Lib\ShortcodeInterface {
    private $base;

    public function __construct() {
        $this->base = 'qodef_team_holder';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
	    if(function_exists('vc_map')) {
		    vc_map(
		    	array(
				    'name'     => esc_html__( 'Team Holder', 'cevian-core' ),
				    'base'     => $this->base,
				    'category' => esc_html__( 'by CEVIAN', 'cevian-core' ),
				    'icon'     => 'icon-wpb-team-holder extended-custom-icon',
				    'as_parent'       => array( 'only' => 'qodef_team' ),
				    'js_view'         => 'VcColumnView',
				    'params'   => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'cevian-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'cevian-core' )
						),
						array(
							'type'        => 'dropdown',
							'class'       => '',
							'heading'     => esc_html__( 'Active element', 'ultima' ),
							'param_name'  => 'active_element',
							'value'       => array(
								esc_html__( 'One', 'cevian-core' )   => '1',
								esc_html__( 'Two', 'cevian-core' )   => '2',
								esc_html__( 'Three', 'cevian-core' ) => '3',
								esc_html__( 'Four', 'cevian-core' ) => '4'
							),
							'save_always' => true
						),
                        array(
                            'type'        => 'dropdown',
                            'class'       => '',
                            'heading'     => esc_html__( 'Column number', 'ultima' ),
                            'param_name'  => 'column_number',
                            'value'       => array(
                                esc_html__( 'Three', 'cevian-core' ) => '3',
                                esc_html__( 'Four', 'cevian-core' ) => '4'
                            ),
                            'save_always' => true
                        )
				    )
			    )
		    );
	    }
    }
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'   => '',
			'active_element' => '1',
            'column_number'  => '3'
		);
		$params = shortcode_atts( $args, $atts );

		$team_holder_data = $this->getTeamHolderData( $params );
		$holder_classes   = $this->getHolderClasses( $params );
		
		$html = '<div class="qodef-team-holder-wrapper ' . esc_attr( $holder_classes ) . '" ' . cevian_select_get_inline_attrs( $team_holder_data ) . '>';
        $html .= '<div class="qodef-th-inner">';
        $html .= do_shortcode( $content );
        $html .= '</div>';
        $html .= '</div>';
		
		return $html;
	}

	private function getTeamHolderData($params) {
		$teamHolderData = array();

		if( $params['active_element'] !== '' ) {
			$teamHolderData['data-active-element'] = $params['active_element'];
		}

		return $teamHolderData;
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();

		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';

		$holderClasses[] .= 'qodef-team-'.$params['column_number'].'-column';
		
		return implode( ' ', $holderClasses );
	}
}