(function ($) {
    'use strict';

    var team = {};
    qodef.modules.progressBar = team;

    team.qodefInitTeam = qodefInitTeam;


    team.qodefOnDocumentReady = qodefOnDocumentReady;

    $(document).ready(qodefOnDocumentReady);

    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function qodefOnDocumentReady() {
        qodefInitTeam();
    }

    /*
     **	Team Holder shortcode
     */
    function qodefInitTeam() {

        var teamHolder = $('.qodef-team-holder-wrapper');

        if (teamHolder.length > 0) {
            teamHolder.each(function () {
                var activeElement = 0;
                var dataActiveElement = 1;
                if (typeof $(this).data('active-element') !== 'undefined' && $(this).data('active-element') !== false) {
                    dataActiveElement = parseFloat($(this).data('active-element'));
                    activeElement = dataActiveElement - 1;
                }

                var numberOfColumns = 5;

                if (typeof $(this).data('active-element') !== 'undefined' && $(this).data('active-element') == 4) {
                    numberOfColumns = 4;
                } else if (typeof $(this).data('active-element') !== 'undefined' && $(this).data('active-element') == 3) {
                    numberOfColumns = 3;
                } else if (typeof $(this).data('active-element') !== 'undefined' && $(this).data('active-element') == 2) {
                    numberOfColumns = 2;
                }

                //validate active element
                activeElement = dataActiveElement > numberOfColumns ? 0 : activeElement;

                $(this).find('.qodef-team-holder').eq(activeElement).addClass('active');
                var activeTeam = $(this);
                $(this).find('.qodef-team-holder').each(function () {
                    $(this).on('mouseenter mouseleave', function () {
                        $(activeTeam).find('.qodef-team-holder').removeClass('active');
                        $(this).addClass('active');
                    });

                });
            });
        }
    }

})(jQuery);