(function($) {
    'use strict';

    var swappingImageGallery = {};
    qodef.modules.swappingImageGallery = swappingImageGallery;

    swappingImageGallery.qodefOnWindowLoad = qodefOnWindowLoad;

    $(window).on('load', qodefOnWindowLoad);

    /*
     All functions to be called on $(window).on('load', ) should be in this function
     */
    function qodefOnWindowLoad() {
        qodefSwappingImageGallery();
    }

    /**
     * Init Owl Carousel
     */
    function qodefSwappingImageGallery() {
        var sliders = $('.qodef-sig-image-holder');

        if (sliders.length) {
            sliders.each(function() {
                var slider = $(this),
                    slideItemsNumber = 1,
                    loop = true,
                    autoplay = false,
                    autoplayHoverPause = false,
                    sliderSpeed = 3500,
                    sliderSpeedAnimation = 700,
                    margin = 0,
                    stagePadding = 0,
                    center = false,
                    autoWidth = false,
                    animateInClass = false, // keyframe css animation
                    animateOutClass = false, // keyframe css animation
                    navigation = false,
                    pagination = true,
                    drag = true,
                    sliderDataHolder = slider;

                if (typeof sliderDataHolder.data('slider-animate-in') !== 'undefined' && sliderDataHolder.data('slider-animate-in') !== false) {
                    animateInClass = sliderDataHolder.data('slider-animate-in');
                }
                if (typeof sliderDataHolder.data('slider-animate-out') !== 'undefined' && sliderDataHolder.data('slider-animate-out') !== false) {
                    animateOutClass = sliderDataHolder.data('slider-animate-out');
                }

                var dotsContainer = $('.qodef-sig-thumbnails-holder');
                dotsContainer.find('.qodef-sig-thumbnail').on('click', function () {
                    var clickedIndex = $(this).index();
                    slider.trigger('to.owl.carousel', clickedIndex);
                });

                slider.waitForImages(function () {
                    $(this).owlCarousel({
                        items: slideItemsNumber,
                        loop: loop,
                        autoplay: autoplay,
                        autoplayHoverPause: autoplayHoverPause,
                        autoplayTimeout: sliderSpeed,
                        smartSpeed: sliderSpeedAnimation,
                        margin: margin,
                        stagePadding: stagePadding,
                        center: center,
                        autoWidth: autoWidth,
                        animateIn: animateInClass,
                        animateOut: animateOutClass,
                        dots: pagination,
                        dotsContainer: dotsContainer,
                        nav: navigation,
                        drag: drag,
                        callbacks: true,
                        navText: [
                            '<span class="qodef-prev-icon fa fa-chevron-left"></span>',
                            '<span class="qodef-next-icon fa fa-chevron-right"></span>'
                        ],
                        onInitialize: function () {
                            slider.css('visibility', 'visible');
                        },
                        onDrag: function (e) {
                            if (qodef.body.hasClass('qodef-smooth-page-transitions-fadeout')) {
                                var sliderIsMoving = e.isTrigger > 0;

                                if (sliderIsMoving) {
                                    slider.addClass('qodef-slider-is-moving');
                                }
                            }
                        },
                        onDragged: function () {
                            if (qodef.body.hasClass('qodef-smooth-page-transitions-fadeout') && slider.hasClass('qodef-slider-is-moving')) {

                                setTimeout(function () {
                                    slider.removeClass('qodef-slider-is-moving');
                                }, 500);
                            }
                        }
                    });

                });
            });
        }
    }
    
})(jQuery);