<?php
namespace CevianCore\CPT\Shortcodes\InteractiveBanners;

use CevianCore\Lib;

class InteractiveBanners implements Lib\ShortcodeInterface {
	
	private $base;
	
	public function __construct() {
		$this->base = 'qodef_interactive_banners';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Interactive Banners', 'cevian-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by CEVIAN', 'cevian-core' ),
					'icon'                      => 'icon-wpb-interactive-banners extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type'        => 'dropdown',
							'param_name'  => 'number_of_items',
							'heading'     => esc_html__( 'Number of items', 'cevian-core' ),
						    'value'       => array(
						        esc_html__('Four', 'galatia-core') => 'four',
						        esc_html__('Five', 'galatia-core') => 'five'
                            )
                        ),
                        array(
							'type'        => 'textfield',
							'param_name'  => 'banners_height',
							'heading'     => esc_html__( 'Interactive banner\'s height' , 'cevian-core' ),
							'description' => esc_html__( 'Insert height in px, leave empty for full height' , 'cevian-core' )
                        ),
                        array(
                            'type'       => 'param_group',
                            'param_name' => 'items',
                            'heading'    => esc_html__( 'Items', 'cevian-core' ),
                            'params'     => array(
                                array(
                                    'type'       => 'textfield',
                                    'param_name' => 'title',
                                    'heading'    => esc_html__( 'Title', 'cevian-core' ),
                                ),
                                array(
                                    'type'       => 'textfield',
                                    'param_name' => 'description',
                                    'heading'    => esc_html__( 'Description', 'cevian-core' ),
                                ),
                                array(
                                    'type'       => 'textfield',
                                    'param_name' => 'link',
                                    'heading'    => esc_html__( 'Link', 'cevian-core' )
                                ),
                                array(
                                    'type'       => 'textfield',
                                    'param_name' => 'link_text',
                                    'heading'    => esc_html__( 'Link Text', 'cevian-core' ),
                                    'dependency' => array( 'element' => 'link', 'not_empty' => true )
                                ),
                                array(
                                    'type'       => 'dropdown',
                                    'param_name' => 'link_target',
                                    'value'      => array_flip(cevian_select_get_link_target_array()),
                                    'heading'    => esc_html__( 'Link Target', 'cevian-core' ),
                                    'dependency' => array( 'element' => 'link', 'not_empty' => true )
                                ),
                                array(
                                    'type'        => 'attach_image',
                                    'param_name'  => 'image',
                                    'heading'     => esc_html__( 'Image', 'cevian-core' ),
                                    'description' => esc_html__( 'Select image from media library', 'cevian-core' )
                                )
                            )
                        )
					)
				)
			);
		}
	}

	public function render( $atts, $content = null ) {
		$args = array(
		    'number_of_items' => '',
		    'banners_height' => '',
            'items' => 'four'
		);

		$params = shortcode_atts( $args, $atts );

		$params['holder_classes'] = $this->getHolderClasses( $params );
        $params['items']          = json_decode( urldecode( $params['items'] ), true );

		$html = cevian_core_get_shortcode_module_template_part( 'templates/interactive-banners', 'interactive-banners', '', $params );

		return $html;
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();

		$holderClasses[] = ! empty( $params['number_of_items'] ) ? ' qodef-ib-' . $params['number_of_items'] : ' qodef-ib-four';
		$holderClasses[] = empty( $params['banners_height'] ) ? ' qodef-ib-full-height' : ' qodef-ib-fixed-height';

		return implode( ' ', $holderClasses );
	}
}