(function($) {
	'use strict';
	
	var interactiveBanner = {};
	qodef.modules.interactiveBanner = interactiveBanner;

	interactiveBanner.qodefInitExpandedGallery = qodefInitInteractiveBanners;


	interactiveBanner.qodefOnDocumentReady = qodefOnDocumentReady;
	
	$(document).ready(qodefOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function qodefOnDocumentReady() {
		qodefInitInteractiveBanners();
	}

	/*
	 **	Init Expanded Gallery shortcode
	 */
	function qodefInitInteractiveBanners(){
		var holder = $('.qodef-interactive-banners');

		if(holder.length){
			holder.each(function(){
				var thisHolder = $(this),
					imagesHolder = thisHolder.find('.qodef-ib-image-holder'),
					items = thisHolder.find('.qodef-ib-item'),
                    delay = qodef.htmlEl.hasClass('touch') ? 700 : 500;


				items.each(function(){
					var thisItem = $(this),
						itemTitle = thisItem.find('.qodef-ib-item-title'),
                        itemText = thisItem.find('.qodef-ib-item-description');


					//banners text appear on hover
                    if(qodef.windowWidth > 1024 && itemTitle.length && itemText.length){
                        var textHeight = itemText.outerHeight(true);
                        itemTitle.css({'transform' : 'translateY(' + textHeight + 'px)'});

                        thisItem.mouseenter( function(){
                            itemTitle.css({'transform' : 'translateY(' + 0 + 'px)'});
                            itemText.removeClass('qodef-hidden');
                        } ).mouseleave( function(){
                            itemTitle.css({'transform' : 'translateY(' + textHeight + 'px)'});
                            itemText.addClass('qodef-hidden');
                        } );
                    }

                    
                    var activeItemTimeout,
                        verticalMaskTimeout,
                        activeIndex, 
                        verticalMask;

                    if(qodef.windowWidth > 1024) {
                        //banners change images logic
                        thisItem.on('mouseenter', function () {
                            if (!thisItem.hasClass('qodef-active')) {
                                items.removeClass('qodef-active');
                                thisItem.addClass('qodef-active');
                                activeIndex = thisItem.data('index');
                                verticalMask = thisHolder.find('.qodef-ib-grid .qodef-ib-grid-line:last-child .qodef-ib-grid-vertical-mask'); //catch only last item to check his transition end
                                thisHolder.addClass('qodef-animating');
                                clearTimeout(activeItemTimeout);
                                clearTimeout(verticalMaskTimeout);
                                
                                // Timeout to make sure masks disappear (fast hovering on items fix)
                                activeItemTimeout = setTimeout(function() {
                                    items.removeClass('qodef-active');
                                    thisItem.addClass('qodef-active');
                                    imagesHolder.removeClass('qodef-active');
                                    imagesHolder.eq(activeIndex).addClass('qodef-active');
                                }, 1000);

                                verticalMaskTimeout = setTimeout(function() {
                                    thisHolder.removeClass('qodef-animating');
                                }, 1200);

                                verticalMask.on(qodef.transitionEnd, function () {
                                    clearTimeout(activeItemTimeout);
                                    clearTimeout(verticalMaskTimeout);
                                    imagesHolder.removeClass('qodef-active');
                                    imagesHolder.eq(activeIndex).addClass('qodef-active');
                                    thisHolder.removeClass('qodef-animating');
                                });
                            }
                        })
                    }

				});
			});
		}

	}
	
})(jQuery);