(function($) {
	'use strict';
	
	var iconShowcase = {};
	qodef.modules.iconShowcase = iconShowcase;

    iconShowcase.qodefInitIconShowcase = qodefInitIconShowcase;


    iconShowcase.qodefOnDocumentReady = qodefOnDocumentReady;
	
	$(document).ready(qodefOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function qodefOnDocumentReady() {
        qodefInitIconShowcase();
	}

	/*
	 ** Interactive Icon Showcase
	 */
    function qodefInitIconShowcase () {
        var interactiveShowcase = $('.qodef-int-icon-showcase'),
            noAnimationOnTouch = $('.qodef-no-animations-on-touch');

        if (interactiveShowcase.length){
            interactiveShowcase.each(function () {
                var thisShowcase = $(this),
                    iconHolders = thisShowcase.find('.qodef-showcase-item-holder'),
                    thisIcons = thisShowcase.find('.qodef-item-custom-icon-outer'),
                    thisContent = thisShowcase.find('.qodef-showcase-content'),
                    thisFirstItem = thisShowcase.find('.qodef-showcase-item-holder:first-child'),
                    thisActiveItem = thisShowcase.find('.qodef-showcase-item-holder.qodef-showcase-active'),
                    isInitialized = false,
                    isPaused = false,
                    currentItem,
                    itemInterval = 3000,
                    numberOfItems = iconHolders.length;

                if(typeof thisShowcase.data('interval') !== 'undefined' && thisShowcase.data('interval') !== false) {
                    itemInterval = thisShowcase.data('interval');
                }

                if (!noAnimationOnTouch.length) {
                    setTimeout(function(){
                        thisShowcase.addClass('qodef-appeared');
                        if (!thisActiveItem.length) {
                            setTimeout(function(){
                                isInitialized = true;
                                thisFirstItem.addClass('qodef-showcase-active');
                                if (thisShowcase.hasClass('qodef-autoplay')) {
                                    showcaseLoop();
                                    thisShowcase.on('mouseenter', function (e) {
                                        isPaused = true;
                                    });
                                    thisShowcase.on('mouseleave', function (e) {
                                        isPaused = false;
                                    });
                                }
                            },2500);
                        }
                    },300);
                    //appear
                    thisShowcase.appear(function(){

                    },{accX: 0, accY: qodefGlobalVars.vars.qodefElementAppearAmount});
                } else {
                    thisFirstItem.addClass('qodef-showcase-active');
                    isInitialized = true;
                }

                //hover actions
                thisIcons.each(function(){
                    var thisIcon = $(this),
                        thisHolder = thisIcon.parent();

                    thisIcon.mouseenter(function(){
                        if (isInitialized == true) {
                            thisHolder.siblings().removeClass('qodef-showcase-active qodef-current');
                            thisHolder.addClass('qodef-showcase-active qodef-current');
                            currentItem = thisShowcase.find('.qodef-current').index(); //reset current loop item to latest hovered item
                        }
                    });
                });

                //loop through the items
                function showcaseLoop()  {
                    currentItem = 0; //start from the first item, index = 0

                    var loop = setInterval(function(){
                        if (!isPaused) {
                            iconHolders.removeClass('qodef-showcase-active qodef-current');
                            if(currentItem == numberOfItems -1){
                                currentItem = 0;
                            }else{
                                currentItem++;
                            }
                            iconHolders.eq(currentItem).addClass('qodef-showcase-active');
                        }
                    }, itemInterval);
                }
            });
        }
    }
	
})(jQuery);