<?php
namespace CevianCore\CPT\Shortcodes\ContentSlider;

use CevianCore\Lib;

class ContentSlider implements Lib\ShortcodeInterface {
    private $base;

    function __construct() {
        $this->base = 'qodef_content_slider';
        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        if(function_exists('vc_map')) {
            vc_map(
                array(
                    'name'      => esc_html__( 'Content Slider', 'cevian-core' ),
                    'base'      => $this->base,
                    'icon'      => 'icon-wpb-content-slider extended-custom-icon',
                    'category'  => esc_html__( 'by CEVIAN', 'cevian-core' ),
                    'params'    => array(
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'number_of_visible_items',
                            'heading'     => esc_html__( 'Number Of Visible Items', 'cevian-core' ),
                            'value'       => array(
                                esc_html__( 'One', 'cevian-core' )   => '1',
                                esc_html__( 'Two', 'cevian-core' )   => '2',
                                esc_html__( 'Three', 'cevian-core' ) => '3',
                                esc_html__( 'Four', 'cevian-core' )  => '4',
                                esc_html__( 'Five', 'cevian-core' )  => '5',
                                esc_html__( 'Six', 'cevian-core' )   => '6'
                            ),
                            'save_always' => true,
                            'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'slider_loop',
                            'heading'     => esc_html__( 'Enable Slider Loop', 'cevian-core' ),
                            'value'       => array_flip( cevian_select_get_yes_no_select_array( false, true ) ),
                            'save_always' => true,
                            'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'slider_autoplay',
                            'heading'     => esc_html__( 'Enable Slider Autoplay', 'cevian-core' ),
                            'value'       => array_flip( cevian_select_get_yes_no_select_array( false, true ) ),
                            'save_always' => true,
                            'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'slider_speed',
                            'heading'     => esc_html__( 'Slide Duration', 'cevian-core' ),
                            'description' => esc_html__( 'Default value is 5000 (ms)', 'cevian-core' ),
                            'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'slider_speed_animation',
                            'heading'     => esc_html__( 'Slide Animation Duration', 'cevian-core' ),
                            'description' => esc_html__( 'Speed of slide animation in milliseconds. Default value is 600.', 'cevian-core' ),
                            'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'slider_padding',
                            'heading'     => esc_html__( 'Enable Slider Padding', 'cevian-core' ),
                            'description' => esc_html__( 'Padding left and right on stage (can see neighbours).', 'cevian-core' ),
                            'value'       => array_flip( cevian_select_get_yes_no_select_array( false ) ),
                            'save_always' => true,
                            'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'slider_navigation',
                            'heading'     => esc_html__( 'Enable Slider Navigation Arrows', 'cevian-core' ),
                            'value'       => array_flip( cevian_select_get_yes_no_select_array( false, true ) ),
                            'save_always' => true,
                            'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'slider_pagination',
                            'heading'     => esc_html__( 'Enable Slider Pagination', 'cevian-core' ),
                            'value'       => array_flip( cevian_select_get_yes_no_select_array( false, true ) ),
                            'save_always' => true,
                            'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
                        ),
                        array(
                            'type'       => 'param_group',
                            'param_name' => 'slide_items',
                            'heading'    => esc_html__( 'Slide Items', 'cevian-core' ),
                            'params'     => array(
                                array(
                                    'type' => 'textarea',
                                    'class' => '',
                                    'heading'    => esc_html__( 'Content', 'cevian-core' ),
                                    'param_name' => 'content',
                                    'value' => '',
                                    'description' => esc_html__('Enter desired content to be shown', 'cevian-core')
                                ),
                                array(
                                    'type'        => 'attach_image',
                                    'param_name'  => 'image',
                                    'heading'     => esc_html__( 'Image', 'cevian-core' ),
                                    'description' => esc_html__( 'Select image from media library', 'cevian-core' )
                                ),
                                array(
                                    'type'        => 'textfield',
                                    'param_name'  => 'image_size',
                                    'heading'     => esc_html__( 'Image Size', 'cevian-core' )
                                )
                            )
                        )
                    )
                )
            );
        }
    }

    public function render( $atts, $content = null ) {
        $args   = array(
            'number_of_visible_items' => '1',
            'slider_loop'             => 'yes',
            'slider_autoplay'         => 'yes',
            'slider_speed'            => '5000',
            'slider_speed_animation'  => '600',
            'slider_padding'          => 'no',
            'slider_navigation'       => 'yes',
            'slider_pagination'       => 'yes',
            'slide_items' => ''
        );
        $params = shortcode_atts( $args, $atts );

        $params['slide_items'] = json_decode( urldecode( $params['slide_items'] ), true );
        $params['slider_data']    = $this->getSliderData( $params );

        $html = cevian_core_get_shortcode_module_template_part( 'templates/content-slider', 'content-slider', '', $params );

        return $html;
    }

    private function getSliderData( $params ) {
        $slider_data = array();

        $slider_data['data-number-of-items']        = $params['number_of_visible_items'] ;
        $slider_data['data-enable-loop']            = ! empty( $params['slider_loop'] ) ? $params['slider_loop'] : '';
        $slider_data['data-enable-autoplay']        = ! empty( $params['slider_autoplay'] ) ? $params['slider_autoplay'] : '';
        $slider_data['data-slider-speed']           = ! empty( $params['slider_speed'] ) ? $params['slider_speed'] : '5000';
        $slider_data['data-slider-speed-animation'] = ! empty( $params['slider_speed_animation'] ) ? $params['slider_speed_animation'] : '600';
        $slider_data['data-slider-padding']         = ! empty( $params['slider_padding'] ) ? $params['slider_padding'] : '';
        $slider_data['data-enable-navigation']      = ! empty( $params['slider_navigation'] ) ? $params['slider_navigation'] : '';
        $slider_data['data-enable-pagination']      = ! empty( $params['slider_pagination'] ) ? $params['slider_pagination'] : '';

        return $slider_data;
    }

}
