<?php
namespace CevianCore\CPT\Shortcodes\ClientsGrid;

use CevianCore\Lib;

class ClientsGrid implements Lib\ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'qodef_clients_grid';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if(function_exists('vc_map')) {
			vc_map(
				array(
					'name'      => esc_html__( 'Clients Grid', 'cevian-core' ),
					'base'      => $this->base,
					'icon'      => 'icon-wpb-clients-grid extended-custom-icon',
					'category'  => esc_html__( 'by CEVIAN', 'cevian-core' ),
					'as_parent' => array( 'only' => 'qodef_clients_carousel_item' ),
					'js_view'   => 'VcColumnView',
					'params'    => array(
						array(
							'type'        => 'dropdown',
							'param_name'  => 'number_of_columns',
							'heading'     => esc_html__( 'Number of Columns', 'cevian-core' ),
							'value'       => array_flip( cevian_select_get_number_of_columns_array( true ) ),
							'save_always' => true
						),
						array(
                            'type'        => 'dropdown',
                            'param_name'  => 'enable_bg_grid',
                            'heading'     => esc_html__( 'Enable Grid', 'cevian-core' ),
                            'value'       => array_flip( cevian_select_get_yes_no_select_array( false, false ) ),
                            'save_always' => true
                        ),
						array(
						    'type'        => 'colorpicker',
                            'param_name'  => 'grid_color',
                            'heading'     => esc_html__( 'Grid Color', 'cevian-core' ),
                            'save_always' => true,
                            'dependency'  => array('element' => 'enable_bg_grid', 'value' => 'yes')
                        ),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'space_between_items',
							'heading'     => esc_html__( 'Space Between Items', 'cevian-core' ),
							'value'       => array_flip( cevian_select_get_space_between_items_array() ),
							'save_always' => true,
                            'dependency'  => array('element' => 'enable_bg_grid', 'value' => 'no')
						),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'item_skin',
                            'heading'     => esc_html__( 'Items Skin', 'cevian-core' ),
                            'value'       => array(
                                esc_html__( 'Default', 'cevian-core' ) => 'default',
                                esc_html__( 'Blue', 'cevian-core' )     => 'blue'
                            )
                        ),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'items_hover_animation',
							'heading'     => esc_html__( 'Items Hover Animation', 'cevian-core' ),
							'value'       => array(
								esc_html__( 'Switch Images', 'cevian-core' ) => 'switch-images',
								esc_html__( 'Roll Over', 'cevian-core' )     => 'roll-over'
							),
							'save_always' => true
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'number_of_columns'     => 'three',
			'enable_bg_grid'        => 'no',
			'grid_color'            => '',
			'space_between_items'   => 'no',
			'item_skin'             => 'default',
			'items_hover_animation' => 'switch-images'
		);
		$params = shortcode_atts( $args, $atts );
		
		$params['holder_classes']   = $this->getHolderClasses( $params, $args );
		$params['content']          = $content;
		$params['grid_color']       = $this->getGridColor($params);
		
		$html = cevian_core_get_shortcode_module_template_part( 'templates/clients-grid', 'clients-grid', '', $params );
		
		return $html;
	}

	private function getHolderClasses( $params, $args ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['number_of_columns'] ) ? 'qodef-' . $params['number_of_columns'] . '-columns' : 'qodef-' . $args['number_of_columns'] . '-columns';
		$holderClasses[] = ! empty( $params['space_between_items'] ) ? 'qodef-' . $params['space_between_items'] . '-space' : 'qodef-' . $args['space_between_items'] . '-space';
		$holderClasses[] = ! empty( $params['items_hover_animation'] ) ? 'qodef-cc-hover-' . $params['items_hover_animation'] : 'qodef-cc-hover-' . $args['items_hover_animation'];
		$holderClasses[] = $params['enable_bg_grid'] == 'yes' ? 'qodef-with-bg-grid' : '';
		$holderClasses[] = $params['item_skin'] == 'default' ? 'qodef-client-default-skin' : 'qodef-client-blue-skin';

		return implode( ' ', $holderClasses );
	}

	private function getGridColor($params){
        $color = '';

        if(!empty($params['grid_color'])){
            $color = $params['grid_color'];
        }

        return $color;
    }
}
