(function($) {
    'use strict';

    var advancedImageSlider = {};
    qodef.modules.qodefInitAdvancedImageSlider = qodefInitAdvancedImageSlider;

    advancedImageSlider.qodefOnDocumentReady = qodefOnDocumentReady;

    $(document).ready(qodefOnDocumentReady);

    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function qodefOnDocumentReady() {
        qodefInitAdvancedImageSlider();
        qodefInitAdvancedImageSliderBackgroundTextFx();
    }

    /**
     * Initializes testimonials vertical logic
     */

    function qodefInitAdvancedImageSlider() {
        var holders = $('.qodef-advanced-image-slider');

        if(holders.length) {
            holders.each(function(){
                var holder = $(this),
                    swiperInstance = holder.find('.swiper-container'),
                    dataHolder = holder.find('.qodef-ais-slider'),
                    loop = true,
                    delay = 3000,
                    speed = 1000,
                    navigation = false,
                    pagination = false;


                if( typeof(dataHolder.data('enable-loop')) !== 'undefined' && dataHolder.data('enable-loop') !== false ){
                    if(dataHolder.data('enable-loop') === 'no'){
                        loop = false;
                    }
                }

                if( typeof(dataHolder.data('slider-speed')) !== 'undefined' && dataHolder.data('slider-speed') !== false){
                    delay = dataHolder.data('slider-speed');
                }

                if( typeof(dataHolder.data('enable-autoplay')) !== 'undefined' && dataHolder.data('enable-autoplay') !== false){
                    if(dataHolder.data('enable-autoplay') === 'no'){
                        delay = 1000000;
                    }
                }

                if( typeof(dataHolder.data('slider-speed-animation')) !== 'undefined' && dataHolder.data('slider-speed-animation') !== false){
                    speed = dataHolder.data('slider-speed-animation');
                }

                if( dataHolder.data('enable-navigation') === 'yes'){
                    navigation = {
                        nextEl: holder.find('.swiper-button-next'),
                        prevEl: holder.find('.swiper-button-prev'),
                    };
                }
                if( dataHolder.data('enable-pagination') === 'yes'){
                    pagination = {
                        el: holder.find('.swiper-pagination'),
                        type: 'bullets',
                        clickable: true,
                    };
                }

                var interleaveOffset = 0.1;

                var swiperSlider = new Swiper (swiperInstance, {
                    loop: loop,
                    autoplay: {
                        delay: delay,
                    },
                    slidesPerView: 1,
                    speed: speed,
                    watchSlidesProgress: true,
                    pagination: pagination,
                    navigation: navigation,
                    autoHeight: true,
                    index : 1,
                    loopAdditionalSlides: 1,
                    bulletClass : 'swiper-pagination-bullet',
                    init: false,
                    on: {
                        progress: function() {
                            var swiper = this;

                            for (var i = 0; i < swiper.slides.length; i++) {
                                var slideProgress = swiper.slides[i].progress;
                                var innerOffset = swiper.width * interleaveOffset;
                                var innerTranslate = slideProgress * innerOffset;
                                swiper.slides[i].querySelector(".qodef-ais-item-inner").style.transform =
                                    "translate3d(" + innerTranslate + "px, 0, 0) scale(1.1)";
                            }
                        },
                        touchStart: function() {
                            var swiper = this;
                            for (var i = 0; i < swiper.slides.length; i++) {
                                swiper.slides[i].style.transition = "";
                            }
                        },
                        setTransition: function(speed) {
                            var swiper = this;
                            for (var i = 0; i < swiper.slides.length; i++) {
                                swiper.slides[i].style.transition = speed + "ms";
                                swiper.slides[i].querySelector(".qodef-ais-item-inner").style.transition =
                                    speed + "ms";
                            }
                        }
                    }
                });

                swiperSlider.on('transitionEnd', function() {
                });


                holder.waitForImages(function() {
                    swiperSlider.init();
                });

                $(window).on('resize', function() {
                });


            });
        }

    }

    function qodefInitAdvancedImageSliderBackgroundTextFx(){
        var vcWithBgRows = $('.vc_row.qodef-row-has-background-text');

        if(vcWithBgRows.length){
            vcWithBgRows.each(function(){
                var thisRow = $(this),
                    auxBgText = thisRow.find('.qodef-row-background-text-holder.qodef-aux'),
                    slider = thisRow.find('.qodef-advanced-image-slider');

                if(! slider.length){
                    auxBgText.remove();
                }
            });
        }
    }

})(jQuery);