<?php
namespace CevianCore\CPT\Shortcodes\AdvancedImageSlider;

use CevianCore\Lib;

class AdvancedImageSlider implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'qodef_advanced_image_slider';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Advanced Image Slider', 'cevian-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by CEVIAN', 'cevian-core' ),
					'icon'                      => 'icon-wpb-advanced-image-slider extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
					    array(
                            'type'        => 'param_group',
                            'param_name'  => 'images',
                            'heading'     => esc_html__( 'Slides', 'cevian-core' ),
                            'params'     => array(
                                array(
                                    'type'        => 'attach_image',
                                    'param_name'  => 'attached_img',
                                    'heading'     => esc_html__( 'Image', 'cevian-core' ),
                                    'description' => esc_html__( 'Select image from media library', 'cevian-core' )
                                )
                            )
                        ),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'slider_loop',
							'heading'     => esc_html__( 'Enable Slider Loop', 'cevian-core' ),
							'value'       => array_flip( cevian_select_get_yes_no_select_array( false, true ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'type', 'value' => array( 'slider', 'carousel' ) ),
							'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'slider_autoplay',
							'heading'     => esc_html__( 'Enable Slider Autoplay', 'cevian-core' ),
							'value'       => array_flip( cevian_select_get_yes_no_select_array( false, true ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'type', 'value' => array( 'slider', 'carousel' ) ),
							'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'slider_pagination',
							'heading'     => esc_html__( 'Enable Slider Pagination', 'cevian-core' ),
							'value'       => array_flip( cevian_select_get_yes_no_select_array( false, true ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'type', 'value' => array( 'slider', 'carousel' ) ),
							'group'       => esc_html__( 'Slider Settings', 'cevian-core' )
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'images'                  => '',
			'enable_image_shadow'     => 'no',
			'slider_loop'             => 'yes',
			'slider_autoplay'         => 'yes',
			'slider_pagination'       => 'yes'
		);
		$params = shortcode_atts( $args, $atts );
		
		$params['holder_classes'] = $this->getHolderClasses( $params, $args );
		$params['slider_data']    = $this->getSliderData( $params );
		
		$params['images']             = json_decode( urldecode( $params['images'] ), true );

		$html = cevian_core_get_shortcode_module_template_part( 'templates/advanced-image-slider', 'advanced-image-slider', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params, $args ) {
		$holderClasses = array();

		return implode( ' ', $holderClasses );
	}
	
	private function getSliderData( $params ) {
		$slider_data = array();
		
		$slider_data['data-enable-loop']            = ! empty( $params['slider_loop'] ) ? $params['slider_loop'] : '';
		$slider_data['data-enable-autoplay']        = ! empty( $params['slider_autoplay'] ) ? $params['slider_autoplay'] : '';
		$slider_data['data-enable-pagination']      = ! empty( $params['slider_pagination'] ) ? $params['slider_pagination'] : '';
		
		return $slider_data;
	}
	
//	private function getGalleryImages( $params ) {
//		$image_ids = array();
//		$images    = array();
//		$i         = 0;
//
//		if ( $params['images'] !== '' ) {
//			$image_ids = explode( ',', $params['images'] );
//		}
//
//		foreach ( $image_ids as $id ) {
//
//			$image['image_id'] = $id;
//			$image_original    = wp_get_attachment_image_src( $id, 'full' );
//			$image['url']      = $image_original[0];
//			$image['title']    = get_the_title( $id );
//			$image['alt']      = get_post_meta( $id, '_wp_attachment_image_alt', true );
//
//			$images[ $i ] = $image;
//			$i ++;
//		}
//
//		return $images;
//	}
//
//	private function getImageSize( $image_size ) {
//		$image_size = trim( $image_size );
//		//Find digits
//		preg_match_all( '/\d+/', $image_size, $matches );
//		if ( in_array( $image_size, array( 'thumbnail', 'thumb', 'medium', 'large', 'full' ) ) ) {
//			return $image_size;
//		} elseif ( ! empty( $matches[0] ) ) {
//			return array(
//				$matches[0][0],
//				$matches[0][1]
//			);
//		} else {
//			return 'full';
//		}
//	}
}