<?php
namespace CevianCore\CPT\Shortcodes\Accordion;

use CevianCore\Lib;

class Accordion implements Lib\ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'qodef_accordion';
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                    => esc_html__( 'Accordion', 'cevian-core' ),
					'base'                    => $this->base,
					'as_parent'               => array( 'only' => 'qodef_accordion_tab' ),
					'content_element'         => true,
					'category'                => esc_html__( 'by CEVIAN', 'cevian-core' ),
					'icon'                    => 'icon-wpb-accordion extended-custom-icon',
					'show_settings_on_create' => true,
					'js_view'                 => 'VcColumnView',
					'params'                  => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'cevian-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'cevian-core' )
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'style',
							'heading'    => esc_html__( 'Style', 'cevian-core' ),
							'value'      => array(
								esc_html__( 'Accordion', 'cevian-core' ) => 'accordion',
								esc_html__( 'Toggle', 'cevian-core' )    => 'toggle'
							)
						),
                        array(
                            'type'       => 'dropdown',
                            'param_name' => 'text_skin',
                            'heading'    => esc_html__( 'Text Skin', 'cevian-core' ),
                            'value'      => array(
                                esc_html__( 'Default', 'cevian-core' ) => '',
                                esc_html__( 'Blue', 'cevian-core' )   => 'blue'
                            ),
                            'dependency' => array( 'element' => 'layout', 'value' => array( 'boxed' ) ),
                            'description' => esc_html__( 'Will change the style of the text, titles, borders and arrows', 'cevian-core' )
                        ),
						array(
							'type'       => 'dropdown',
							'param_name' => 'layout',
							'heading'    => esc_html__( 'Layout', 'cevian-core' ),
							'value'      => array(
								esc_html__( 'Boxed', 'cevian-core' )  => 'boxed',
								esc_html__( 'Simple', 'cevian-core' ) => 'simple'
							)
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'background_skin',
							'heading'    => esc_html__( 'Background Skin', 'cevian-core' ),
							'value'      => array(
								esc_html__( 'Default', 'cevian-core' ) => '',
								esc_html__( 'White', 'cevian-core' )   => 'white'
							),
							'dependency' => array( 'element' => 'layout', 'value' => array( 'boxed' ) )
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$default_atts = array(
			'custom_class'    => '',
			'title'           => '',
			'text_skin'       => 'default',
			'style'           => 'accordion',
			'layout'          => 'boxed',
			'background_skin' => ''
		);
		$params       = shortcode_atts( $default_atts, $atts );
		
		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['content']        = $content;
		
		wp_enqueue_script( 'jquery-ui-accordion' );
		
		$output = cevian_core_get_shortcode_module_template_part( 'templates/accordion-holder-template', 'accordions', '', $params );
		
		return $output;
	}
	
	private function getHolderClasses( $params ) {
		$holder_classes = array( 'qodef-ac-default' );
		
		$holder_classes[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holder_classes[] = $params['style'] == 'toggle' ? 'qodef-toggle' : 'qodef-accordion';
		$holder_classes[] = ! empty( $params['layout'] ) ? 'qodef-ac-' . esc_attr( $params['layout'] ) : '';
		$holder_classes[] = ! empty( $params['background_skin'] ) ? 'qodef-' . esc_attr( $params['background_skin'] ) . '-skin' : '';
        $holder_classes[] = ! empty( $params['text_skin'] ) ? 'qodef-' . esc_attr( $params['text_skin'] ) . '-text-skin' : '';
		
		return implode( ' ', $holder_classes );
	}
}
