<?php

if ( ! function_exists( 'cevian_core_map_portfolio_meta' ) ) {
	function cevian_core_map_portfolio_meta() {
		global $cevian_select_global_Framework;
		
		$cevian_pages = array();
		$pages      = get_pages();
		foreach ( $pages as $page ) {
			$cevian_pages[ $page->ID ] = $page->post_title;
		}
		
		//Portfolio Images
		
		$cevian_portfolio_images = new CevianSelectClassMetaBox( 'portfolio-item', esc_html__( 'Portfolio Images (multiple upload)', 'cevian-core' ), '', '', 'portfolio_images' );
		$cevian_select_global_Framework->qodeMetaBoxes->addMetaBox( 'portfolio_images', $cevian_portfolio_images );
		
		$cevian_portfolio_image_gallery = new CevianSelectClassMultipleImages( 'qodef-portfolio-image-gallery', esc_html__( 'Portfolio Images', 'cevian-core' ), esc_html__( 'Choose your portfolio images', 'cevian-core' ) );
		$cevian_portfolio_images->addChild( 'qodef-portfolio-image-gallery', $cevian_portfolio_image_gallery );
		
		//Portfolio Single Upload Images/Videos 
		
		$cevian_portfolio_images_videos = cevian_select_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Portfolio Images/Videos (single upload)', 'cevian-core' ),
				'name'  => 'qodef_portfolio_images_videos'
			)
		);
		cevian_select_add_repeater_field(
			array(
				'name'        => 'qodef_portfolio_single_upload',
				'parent'      => $cevian_portfolio_images_videos,
				'button_text' => esc_html__( 'Add Image/Video', 'cevian-core' ),
				'fields'      => array(
					array(
						'type'        => 'select',
						'name'        => 'file_type',
						'label'       => esc_html__( 'File Type', 'cevian-core' ),
						'options' => array(
							'image' => esc_html__('Image','cevian-core'),
							'video' => esc_html__('Video','cevian-core'),
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'single_image',
						'label'       => esc_html__( 'Image', 'cevian-core' ),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'image'
							)
						)
					),
					array(
						'type'        => 'select',
						'name'        => 'video_type',
						'label'       => esc_html__( 'Video Type', 'cevian-core' ),
						'options'	  => array(
							'youtube' => esc_html__('YouTube', 'cevian-core'),
							'vimeo' => esc_html__('Vimeo', 'cevian-core'),
							'self' => esc_html__('Self Hosted', 'cevian-core'),
						),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'video'
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_id',
						'label'       => esc_html__( 'Video ID', 'cevian-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => array('youtube','vimeo')
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_mp4',
						'label'       => esc_html__( 'Video mp4', 'cevian-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'video_cover_image',
						'label'       => esc_html__( 'Video Cover Image', 'cevian-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					)
				)
			)
		);
		
		//Portfolio Additional Sidebar Items
		
		$cevian_additional_sidebar_items = cevian_select_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Additional Portfolio Sidebar Items', 'cevian-core' ),
				'name'  => 'portfolio_properties'
			)
		);

		cevian_select_add_repeater_field(
			array(
				'name'        => 'qodef_portfolio_properties',
				'parent'      => $cevian_additional_sidebar_items,
				'button_text' => esc_html__( 'Add New Item', 'cevian-core' ),
				'fields'      => array(
					array(
						'type'        => 'text',
						'name'        => 'item_title',
						'label'       => esc_html__( 'Item Title', 'cevian-core' ),
					),
					array(
						'type'        => 'text',
						'name'        => 'item_text',
						'label'       => esc_html__( 'Item Text', 'cevian-core' )
					),
					array(
						'type'        => 'text',
						'name'        => 'item_url',
						'label'       => esc_html__( 'Enter Full URL for Item Text Link', 'cevian-core' )
					)
				)
			)
		);
	}
	
	add_action( 'cevian_select_action_meta_boxes_map', 'cevian_core_map_portfolio_meta', 40 );
}