<?php

if ( class_exists( 'CevianCoreClassWidget' ) ) {
	class CevianSelectClassSeparatorWidget extends CevianCoreClassWidget {
		public function __construct() {
			parent::__construct(
				'qodef_separator_widget',
				esc_html__( 'Cevian Separator Widget', 'cevian' ),
				array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'cevian' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'    => 'dropdown',
					'name'    => 'type',
					'title'   => esc_html__( 'Type', 'cevian' ),
					'options' => array(
						'normal'     => esc_html__( 'Normal', 'cevian' ),
						'full-width' => esc_html__( 'Full Width', 'cevian' )
					)
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'position',
					'title'   => esc_html__( 'Position', 'cevian' ),
					'options' => array(
						'center' => esc_html__( 'Center', 'cevian' ),
						'left'   => esc_html__( 'Left', 'cevian' ),
						'right'  => esc_html__( 'Right', 'cevian' )
					)
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'border_style',
					'title'   => esc_html__( 'Style', 'cevian' ),
					'options' => array(
						'solid'  => esc_html__( 'Solid', 'cevian' ),
						'dashed' => esc_html__( 'Dashed', 'cevian' ),
						'dotted' => esc_html__( 'Dotted', 'cevian' )
					)
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'cevian' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'width',
					'title' => esc_html__( 'Width (px or %)', 'cevian' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'thickness',
					'title' => esc_html__( 'Thickness (px)', 'cevian' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'top_margin',
					'title' => esc_html__( 'Top Margin (px or %)', 'cevian' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'bottom_margin',
					'title' => esc_html__( 'Bottom Margin (px or %)', 'cevian' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			if ( ! is_array( $instance ) ) {
				$instance = array();
			}
			
			//prepare variables
			$params = '';
			
			//is instance empty?
			if ( is_array( $instance ) && count( $instance ) ) {
				//generate shortcode params
				foreach ( $instance as $key => $value ) {
					$params .= " $key='$value' ";
				}
			}
			
			echo '<div class="widget qodef-separator-widget">';
			echo do_shortcode( "[qodef_separator $params]" ); // XSS OK
			echo '</div>';
		}
	}
}