<?php

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
if ( function_exists( 'vc_set_as_theme' ) ) {
	vc_set_as_theme( true );
}

/**
 * Change path for overridden templates
 */
if ( function_exists( 'vc_set_shortcodes_templates_dir' ) ) {
	$dir = SELECT_ROOT_DIR . '/vc-templates';
	vc_set_shortcodes_templates_dir( $dir );
}

if ( ! function_exists( 'cevian_select_configure_visual_composer_frontend_editor' ) ) {
	/**
	 * Configuration for Visual Composer FrontEnd Editor
	 * Hooks on vc_after_init action
	 */
	function cevian_select_configure_visual_composer_frontend_editor() {
		/**
		 * Remove frontend editor
		 */
		if ( function_exists( 'vc_disable_frontend' ) ) {
			vc_disable_frontend();
		}
	}
	
	add_action( 'vc_after_init', 'cevian_select_configure_visual_composer_frontend_editor' );
}

if ( ! function_exists( 'cevian_select_vc_row_map' ) ) {
	/**
	 * Map VC Row shortcode
	 * Hooks on vc_after_init action
	 */
	function cevian_select_vc_row_map() {
		
		/******* VC Row shortcode - begin *******/
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Select Row Content Width', 'cevian' ),
				'value'      => array(
					esc_html__( 'Full Width', 'cevian' ) => 'full-width',
					esc_html__( 'In Grid', 'cevian' )    => 'grid'
				),
				'group'      => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'anchor',
				'heading'     => esc_html__( 'Select Anchor ID', 'cevian' ),
				'description' => esc_html__( 'For example "home"', 'cevian' ),
				'group'       => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Select Background Color', 'cevian' ),
				'group'      => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Select Background Image', 'cevian' ),
				'group'      => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'background_image_position',
				'heading'     => esc_html__( 'Select Background Position', 'cevian' ),
				'description' => esc_html__( 'Set the starting position of a background image, default value is top left', 'cevian' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Select Disable Background Image', 'cevian' ),
				'value'       => array(
					esc_html__( 'Never', 'cevian' )        => '',
					esc_html__( 'Below 1280px', 'cevian' ) => '1280',
					esc_html__( 'Below 1024px', 'cevian' ) => '1024',
					esc_html__( 'Below 768px', 'cevian' )  => '768',
					esc_html__( 'Below 680px', 'cevian' )  => '680',
					esc_html__( 'Below 480px', 'cevian' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'cevian' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'parallax_background_image',
				'heading'    => esc_html__( 'Select Parallax Background Image', 'cevian' ),
				'group'      => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'parallax_bg_speed',
				'heading'     => esc_html__( 'Select Parallax Speed', 'cevian' ),
				'description' => esc_html__( 'Set your parallax speed. Default value is 1.', 'cevian' ),
				'dependency'  => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'textfield',
				'param_name' => 'parallax_bg_height',
				'heading'    => esc_html__( 'Select Parallax Section Height (px)', 'cevian' ),
				'dependency' => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'      => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Select Content Aligment', 'cevian' ),
				'value'      => array(
					esc_html__( 'Default', 'cevian' ) => '',
					esc_html__( 'Left', 'cevian' )    => 'left',
					esc_html__( 'Center', 'cevian' )  => 'center',
					esc_html__( 'Right', 'cevian' )   => 'right'
				),
				'group'      => esc_html__( 'Select Settings', 'cevian' )
			)
		);

        vc_add_param( 'vc_row',
            array(
                'type'       => 'textfield',
                'param_name' => 'row_background_text_1',
                'heading'    => esc_html__( 'Select Background Text 1', 'cevian' ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'textfield',
                'param_name' => 'row_background_text_2',
                'heading'    => esc_html__( 'Select Background Text 2', 'cevian' ),
                'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'textfield',
                'param_name' => 'row_background_text_size',
                'heading'    => esc_html__( 'Select Background Text Size', 'cevian' ),
                'description' => esc_html__( 'Set the background text size in px or em', 'cevian' ),
                'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'textfield',
                'param_name' => 'row_background_text_size_1440',
                'heading'    => esc_html__( 'Select Background Text Size 1280px-1440px', 'cevian' ),
                'description' => esc_html__( 'Set the background text size in px or em', 'cevian' ),
                'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'textfield',
                'param_name' => 'row_background_text_size_1280',
                'heading'    => esc_html__( 'Select Background Text Size 1024px-1280px', 'cevian' ),
                'description' => esc_html__( 'Set the background text size in px or em', 'cevian' ),
                'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'dropdown',
                'param_name' => 'row_enable_grid',
                'group'      => esc_html__( 'Select Settings', 'cevian' ),
                'heading'    => 'Enable Row Grid',
                'description'=> 'Works with: Icon With Text, Image WIth Text',
                'value'      => array_flip( cevian_select_get_yes_no_select_array( false, false ) )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'colorpicker',
                'param_name' => 'row_background_text_color',
                'heading'    => esc_html__( 'Select Background Text Color', 'cevian' ),
                'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'dropdown',
                'param_name' => 'row_background_text_align',
                'heading'    => esc_html__( 'Select Background Text Align', 'cevian' ),
                'value'      => array(
                    esc_html__( 'Default', 'cevian' ) => '',
                    esc_html__( 'Left', 'cevian' )    => 'left',
                    esc_html__( 'Center', 'cevian' )  => 'center',
                    esc_html__( 'Right', 'cevian' )   => 'right'
                ),
                'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'dropdown',
                'param_name' => 'row_background_text_vertical_align',
                'heading'    => esc_html__( 'Select Background Vertical Align', 'cevian' ),
                'value'      => array(
                    esc_html__( 'Middle', 'cevian' )   => 'middle',
                    esc_html__( 'Top', 'cevian' )      => 'top',
                    esc_html__( 'Bottom', 'cevian' )   => 'bottom'
                ),
                'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'textfield',
                'param_name' => 'row_background_text_padding_top',
                'heading'    => esc_html__( 'Select Background Text Top Padding', 'cevian' ),
                'description' => esc_html__( 'Set the value of top padding in px or %', 'cevian' ),
                'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'textfield',
                'param_name' => 'row_background_text_padding_left',
                'heading'    => esc_html__( 'Select Background Text Left Padding', 'cevian' ),
                'description' => esc_html__( 'Set the value of top padding in px or %', 'cevian' ),
                'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'textfield',
                'param_name' => 'row_background_text_padding_top_1440',
                'heading'    => esc_html__( 'Select Background Text Top Padding Size 1280px-1440px', 'cevian' ),
                'description' => esc_html__( 'Set the background text padding in px or em', 'cevian' ),
                'dependency' => array( 'element' => 'row_background_text_padding_top', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'textfield',
                'param_name' => 'row_background_text_padding_top_1280',
                'heading'    => esc_html__( 'Select Background Text Top Padding Size 1024px-1280px', 'cevian' ),
                'description' => esc_html__( 'Set the background text padding in px or em', 'cevian' ),
                'dependency' => array( 'element' => 'row_background_text_padding_top', 'not_empty' => true ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

        vc_add_param( 'vc_row',
            array(
                'type'       => 'dropdown',
                'param_name' => 'row_background_text_animation',
                'heading'    => esc_html__( 'Animate Background Text', 'cevian' ),
                'value'      => array_flip( cevian_select_get_yes_no_select_array(false, true) ),
                'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                'description'    => esc_html__( 'Animate background text when row appears in viewport', 'cevian' ),
                'group'      => esc_html__( 'Select Settings', 'cevian' )
            )
        );

		do_action( 'cevian_select_action_additional_vc_row_params' );
		
		/******* VC Row shortcode - end *******/
		
		/******* VC Row Inner shortcode - begin *******/
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Select Row Content Width', 'cevian' ),
				'value'      => array(
					esc_html__( 'Full Width', 'cevian' ) => 'full-width',
					esc_html__( 'In Grid', 'cevian' )    => 'grid'
				),
				'group'      => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Select Background Color', 'cevian' ),
				'group'      => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Select Background Image', 'cevian' ),
				'group'      => esc_html__( 'Select Settings', 'cevian' )
			)
		);

        vc_add_param( 'vc_row_inner',
            array(
                'type'       => 'dropdown',
                'param_name' => 'row_inner_enable_grid',
                'group'      => esc_html__( 'Select Settings', 'cevian' ),
                'heading'    => 'Enable Row Grid',
                'description'=> 'Works with: Icon With Text, Image WIth Text',
                'value'      => array_flip( cevian_select_get_yes_no_select_array( false, false ) )
            )
        );
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'textfield',
				'param_name'  => 'background_image_position',
				'heading'     => esc_html__( 'Select Background Position', 'cevian' ),
				'description' => esc_html__( 'Set the starting position of a background image, default value is top left', 'cevian' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Select Disable Background Image', 'cevian' ),
				'value'       => array(
					esc_html__( 'Never', 'cevian' )        => '',
					esc_html__( 'Below 1280px', 'cevian' ) => '1280',
					esc_html__( 'Below 1024px', 'cevian' ) => '1024',
					esc_html__( 'Below 768px', 'cevian' )  => '768',
					esc_html__( 'Below 680px', 'cevian' )  => '680',
					esc_html__( 'Below 480px', 'cevian' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'cevian' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Select Content Aligment', 'cevian' ),
				'value'      => array(
					esc_html__( 'Default', 'cevian' ) => '',
					esc_html__( 'Left', 'cevian' )    => 'left',
					esc_html__( 'Center', 'cevian' )  => 'center',
					esc_html__( 'Right', 'cevian' )   => 'right'
				),
				'group'      => esc_html__( 'Select Settings', 'cevian' )
			)
		);
		
		/******* VC Row Inner shortcode - end *******/
		
		/******* VC Revolution Slider shortcode - begin *******/
		
		if ( cevian_select_is_plugin_installed( 'revolution-slider' ) ) {
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'enable_paspartu',
					'heading'     => esc_html__( 'Select Enable Passepartout', 'cevian' ),
					'value'       => array_flip( cevian_select_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'group'       => esc_html__( 'Select Settings', 'cevian' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'paspartu_size',
					'heading'     => esc_html__( 'Select Passepartout Size', 'cevian' ),
					'value'       => array(
						esc_html__( 'Tiny', 'cevian' )   => 'tiny',
						esc_html__( 'Small', 'cevian' )  => 'small',
						esc_html__( 'Normal', 'cevian' ) => 'normal',
						esc_html__( 'Large', 'cevian' )  => 'large'
					),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Select Settings', 'cevian' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_side_paspartu',
					'heading'     => esc_html__( 'Select Disable Side Passepartout', 'cevian' ),
					'value'       => array_flip( cevian_select_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Select Settings', 'cevian' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_top_paspartu',
					'heading'     => esc_html__( 'Select Disable Top Passepartout', 'cevian' ),
					'value'       => array_flip( cevian_select_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Select Settings', 'cevian' )
				)
			);
		}
		
		/******* VC Revolution Slider shortcode - end *******/
	}
	
	add_action( 'vc_after_init', 'cevian_select_vc_row_map' );
}