<?php

if ( ! function_exists( 'cevian_select_get_title_types_meta_boxes' ) ) {
	function cevian_select_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'cevian_select_filter_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'cevian' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( SELECT_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'cevian_select_map_title_meta' ) ) {
	function cevian_select_map_title_meta() {
		$title_type_meta_boxes = cevian_select_get_title_types_meta_boxes();
		
		$title_meta_box = cevian_select_create_meta_box(
			array(
				'scope' => apply_filters( 'cevian_select_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'cevian' ),
				'name'  => 'title_meta'
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'cevian' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'cevian' ),
				'parent'        => $title_meta_box,
				'options'       => cevian_select_get_yes_no_select_array()
			)
		);
		
			$show_title_area_meta_container = cevian_select_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'qodef_show_title_area_meta_container',
					'dependency' => array(
						'hide' => array(
							'qodef_show_title_area_meta' => 'no'
						)
					)
				)
			);
		
				cevian_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'cevian' ),
						'description'   => esc_html__( 'Choose title type', 'cevian' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				cevian_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'cevian' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'cevian' ),
						'options'       => cevian_select_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'cevian' ),
						'description' => esc_html__( 'Set a height for Title Area', 'cevian' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'cevian' ),
						'description' => esc_html__( 'Choose a background color for title area', 'cevian' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'cevian' ),
						'description' => esc_html__( 'Choose an Image for title area', 'cevian' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				cevian_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'cevian' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'cevian' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'cevian' ),
							'hide'                => esc_html__( 'Hide Image', 'cevian' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'cevian' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'cevian' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'cevian' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'cevian' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'cevian' )
						)
					)
				);

                cevian_select_create_meta_box_field(
                    array(
                        'name'          => 'qodef_title_area_border_meta',
                        'type'          => 'select',
                        'label'         => esc_html__( 'Title Area Border', 'cevian' ),
                        'description'   => esc_html__( 'Set border on title area', 'cevian' ),
                        'parent'        => $show_title_area_meta_container,
                        'default_value' => '',
                        'options'       => cevian_select_get_yes_no_select_array()
                    )
                );

                $title_border_color_container = cevian_select_add_admin_container(
                    array(
                        'parent'          => $show_title_area_meta_container,
                        'name'            => 'qodef_title_border_color_container',
                        'dependency' => array(
                            'hide' => array(
                                'qodef_title_area_border_meta' => 'no'
                            )
                        )
                    )
                );

                cevian_select_create_meta_box_field(
                    array(
                        'type'          => 'color',
                        'name'          => 'qodef_title_area_border_color_meta',
                        'label'         => esc_html__( 'Title Area Border Color', 'cevian' ),
                        'description'   => esc_html__( 'Set border color', 'cevian' ),
                        'parent'        => $title_border_color_container
                    )
                );
				
				cevian_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'cevian' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'cevian' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'cevian' ),
							'header-bottom' => esc_html__( 'From Bottom of Header', 'cevian' ),
							'window-top'    => esc_html__( 'From Window Top', 'cevian' )
						)
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'cevian' ),
						'options'       => cevian_select_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'cevian' ),
						'description' => esc_html__( 'Choose a color for title text', 'cevian' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'cevian' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'cevian' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				cevian_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'cevian' ),
						'options'       => cevian_select_get_title_tag( true, array( 'p' => 'p' ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'cevian' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'cevian' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'cevian_select_action_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'cevian_select_action_meta_boxes_map', 'cevian_select_map_title_meta', 60 );
}