<?php

if ( ! function_exists( 'cevian_select_sidebar_options_map' ) ) {
	function cevian_select_sidebar_options_map() {
		
		cevian_select_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'cevian' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = cevian_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'cevian' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		cevian_select_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'cevian' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'cevian' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => cevian_select_get_custom_sidebars_options()
		) );
		
		$cevian_custom_sidebars = cevian_select_get_custom_sidebars();
		if ( count( $cevian_custom_sidebars ) > 0 ) {
			cevian_select_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'cevian' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'cevian' ),
				'parent'      => $sidebar_panel,
				'options'     => $cevian_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'cevian_select_action_options_map', 'cevian_select_sidebar_options_map', cevian_select_set_options_map_position( 'sidebar' ) );
}