<?php

if ( ! function_exists( 'cevian_select_map_sidebar_meta' ) ) {
	function cevian_select_map_sidebar_meta() {
		$qodef_sidebar_meta_box = cevian_select_create_meta_box(
			array(
				'scope' => apply_filters( 'cevian_select_filter_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'cevian' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'cevian' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'cevian' ),
				'parent'      => $qodef_sidebar_meta_box,
                'options'       => cevian_select_get_custom_sidebars_options( true )
			)
		);
		
		$qodef_custom_sidebars = cevian_select_get_custom_sidebars();
		if ( count( $qodef_custom_sidebars ) > 0 ) {
			cevian_select_create_meta_box_field(
				array(
					'name'        => 'qodef_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'cevian' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'cevian' ),
					'parent'      => $qodef_sidebar_meta_box,
					'options'     => $qodef_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'cevian_select_action_meta_boxes_map', 'cevian_select_map_sidebar_meta', 31 );
}