<?php

if ( ! function_exists( 'cevian_select_map_footer_meta' ) ) {
	function cevian_select_map_footer_meta() {
		
		$footer_meta_box = cevian_select_create_meta_box(
			array(
				'scope' => apply_filters( 'cevian_select_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'footer_meta' ),
				'title' => esc_html__( 'Footer', 'cevian' ),
				'name'  => 'footer_meta'
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_disable_footer_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Disable Footer For This Page', 'cevian' ),
				'description'   => esc_html__( 'Enabling this option will hide footer on this page', 'cevian' ),
				'options'       => cevian_select_get_yes_no_select_array(),
				'parent'        => $footer_meta_box
			)
		);
		
		$show_footer_meta_container = cevian_select_add_admin_container(
			array(
				'name'       => 'qodef_show_footer_meta_container',
				'parent'     => $footer_meta_box,
				'dependency' => array(
					'hide' => array(
						'qodef_disable_footer_meta' => 'yes'
					)
				)
			)
		);
		
			cevian_select_create_meta_box_field(
				array(
					'name'          => 'qodef_footer_in_grid_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Footer in Grid', 'cevian' ),
					'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'cevian' ),
					'options'       => cevian_select_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
			
			cevian_select_create_meta_box_field(
				array(
					'name'          => 'qodef_uncovering_footer_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Uncovering Footer', 'cevian' ),
					'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'cevian' ),
					'options'       => cevian_select_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			cevian_select_create_meta_box_field(
				array(
					'name'          => 'qodef_show_footer_top_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Top', 'cevian' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'cevian' ),
					'options'       => cevian_select_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			$footer_top_styles_group = cevian_select_add_admin_group(
				array(
					'name'        => 'footer_top_styles_group',
					'title'       => esc_html__( 'Footer Top Styles', 'cevian' ),
					'description' => esc_html__( 'Define style for footer top area', 'cevian' ),
					'parent'      => $show_footer_meta_container,
					'dependency'  => array(
						'hide' => array(
							'qodef_show_footer_top_meta' => 'no'
						)
					)
				)
			);
			
			$footer_top_styles_row_1 = cevian_select_add_admin_row(
				array(
					'name'   => 'footer_top_styles_row_1',
					'parent' => $footer_top_styles_group
				)
			);
		
				cevian_select_create_meta_box_field(
					array(
						'name'   => 'qodef_footer_top_background_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Background Color', 'cevian' ),
						'parent' => $footer_top_styles_row_1
					)
				);
		
				cevian_select_create_meta_box_field(
					array(
						'name'   => 'qodef_footer_top_border_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Border Color', 'cevian' ),
						'parent' => $footer_top_styles_row_1
					)
				);
		
				cevian_select_create_meta_box_field(
					array(
						'name'   => 'qodef_footer_top_border_width_meta',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Border Width', 'cevian' ),
						'parent' => $footer_top_styles_row_1,
						'args'   => array(
							'suffix' => 'px'
						)
					)
				);
			
			cevian_select_create_meta_box_field(
				array(
					'name'          => 'qodef_show_footer_bottom_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Bottom', 'cevian' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'cevian' ),
					'options'       => cevian_select_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			$footer_bottom_styles_group = cevian_select_add_admin_group(
				array(
					'name'        => 'footer_bottom_styles_group',
					'title'       => esc_html__( 'Footer Bottom Styles', 'cevian' ),
					'description' => esc_html__( 'Define style for footer bottom area', 'cevian' ),
					'parent'      => $show_footer_meta_container,
					'dependency'  => array(
						'hide' => array(
							'qodef_show_footer_bottom_meta' => 'no'
						)
					)
				)
			);
			
			$footer_bottom_styles_row_1 = cevian_select_add_admin_row(
				array(
					'name'   => 'footer_bottom_styles_row_1',
					'parent' => $footer_bottom_styles_group
				)
			);
			
				cevian_select_create_meta_box_field(
					array(
						'name'   => 'qodef_footer_bottom_background_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Background Color', 'cevian' ),
						'parent' => $footer_bottom_styles_row_1
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'   => 'qodef_footer_bottom_border_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Border Color', 'cevian' ),
						'parent' => $footer_bottom_styles_row_1
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'   => 'qodef_footer_bottom_border_width_meta',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Border Width', 'cevian' ),
						'parent' => $footer_bottom_styles_row_1,
						'args'   => array(
							'suffix' => 'px'
						)
					)
				);
	}
	
	add_action( 'cevian_select_action_meta_boxes_map', 'cevian_select_map_footer_meta', 70 );
}