<?php

if ( ! function_exists( 'cevian_select_reset_options_map' ) ) {
	/**
	 * Reset options panel
	 */
	function cevian_select_reset_options_map() {
		
		cevian_select_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__( 'Reset', 'cevian' ),
				'icon'  => 'fa fa-retweet'
			)
		);
		
		$panel_reset = cevian_select_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__( 'Reset', 'cevian' )
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'reset_to_defaults',
				'default_value' => 'no',
				'label'         => esc_html__( 'Reset to Defaults', 'cevian' ),
				'description'   => esc_html__( 'This option will reset all Select Options values to defaults', 'cevian' ),
				'parent'        => $panel_reset
			)
		);
	}
	
	add_action( 'cevian_select_action_options_map', 'cevian_select_reset_options_map', cevian_select_set_options_map_position( 'reset' ) );
}